/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.core;

import com.siemens.ct.exi.EXIFactory;
import com.siemens.ct.exi.FidelityOptions;
import com.siemens.ct.exi.context.QNameContext;
import com.siemens.ct.exi.core.container.NamespaceDeclaration;
import com.siemens.ct.exi.datatype.BooleanDatatype;
import com.siemens.ct.exi.exceptions.EXIException;
import com.siemens.ct.exi.exceptions.ErrorHandler;
import com.siemens.ct.exi.grammars.Grammars;
import com.siemens.ct.exi.grammars.event.StartElement;
import com.siemens.ct.exi.grammars.grammar.Grammar;
import com.siemens.ct.exi.helpers.DefaultErrorHandler;
import com.siemens.ct.exi.util.xml.QNameUtilities;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public abstract class AbstractEXIBodyCoder {
    protected final EXIFactory exiFactory;
    protected final Grammars grammar;
    protected final FidelityOptions fidelityOptions;
    protected final boolean preservePrefix;
    protected final boolean preserveLexicalValues;
    protected ErrorHandler errorHandler;
    protected final BooleanDatatype booleanDatatype;
    private ElementContext elementContext;
    protected ElementContext[] elementContextStack;
    protected int elementContextStackIndex;
    public static final int INITIAL_STACK_SIZE = 16;
    protected Map<QName, StartElement> runtimeElements;

    public AbstractEXIBodyCoder(EXIFactory exiFactory) throws EXIException {
        this.exiFactory = exiFactory;
        this.grammar = exiFactory.getGrammars();
        this.fidelityOptions = exiFactory.getFidelityOptions();
        this.preservePrefix = this.fidelityOptions.isFidelityEnabled("PRESERVE_PREFIXES");
        this.preserveLexicalValues = this.fidelityOptions.isFidelityEnabled("PRESERVE_LEXICAL_VALUES");
        this.errorHandler = new DefaultErrorHandler();
        this.runtimeElements = new HashMap<QName, StartElement>();
        this.elementContextStack = new ElementContext[16];
        this.booleanDatatype = new BooleanDatatype(null);
    }

    protected final Grammar getCurrentGrammar() {
        return this.elementContext.gr;
    }

    protected final void updateCurrentRule(Grammar newCurrentGrammar) {
        this.elementContext.gr = newCurrentGrammar;
    }

    protected final ElementContext getElementContext() {
        return this.elementContext;
    }

    protected final void updateElementContext(ElementContext elementContext) {
        this.elementContext = elementContext;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    protected void initForEachRun() throws EXIException, IOException {
        this.runtimeElements.clear();
        Grammar startRule = this.exiFactory.isFragment() ? this.grammar.getFragmentGrammar() : this.grammar.getDocumentGrammar();
        this.elementContextStackIndex = 0;
        this.elementContextStack[this.elementContextStackIndex] = this.elementContext = new ElementContext(null, startRule);
    }

    public final void declarePrefix(String pfx, String uri) {
        this.declarePrefix(new NamespaceDeclaration(uri, pfx));
    }

    protected final void declarePrefix(NamespaceDeclaration nsDecl) {
        if (this.elementContext.nsDeclarations == null) {
            this.elementContext.nsDeclarations = new ArrayList<NamespaceDeclaration>();
        }
        assert (!this.elementContext.nsDeclarations.contains(nsDecl));
        this.elementContext.nsDeclarations.add(nsDecl);
    }

    public final String getURI(String prefix) {
        int i = this.elementContextStackIndex;
        while (i > 0) {
            ElementContext ec = this.elementContextStack[i];
            if (ec.nsDeclarations != null) {
                for (NamespaceDeclaration ns : ec.nsDeclarations) {
                    if (!ns.prefix.equals(prefix)) continue;
                    return ns.namespaceURI;
                }
            }
            --i;
        }
        return prefix.length() == 0 ? "" : null;
    }

    protected void pushElement(Grammar updContextGrammar, StartElement se) {
        this.elementContext.gr = updContextGrammar;
        if (this.elementContextStack.length == ++this.elementContextStackIndex) {
            ElementContext[] elementContextStackNew = new ElementContext[this.elementContextStack.length << 2];
            System.arraycopy(this.elementContextStack, 0, elementContextStackNew, 0, this.elementContextStack.length);
            this.elementContextStack = elementContextStackNew;
        }
        this.elementContextStack[this.elementContextStackIndex] = this.elementContext = new ElementContext(se.getQNameContext(), se.getGrammar());
    }

    protected final ElementContext popElement() {
        assert (this.elementContextStackIndex > 0);
        ElementContext poppedEC = this.elementContextStack[this.elementContextStackIndex];
        this.elementContextStack[this.elementContextStackIndex--] = null;
        this.elementContext = this.elementContextStack[this.elementContextStackIndex];
        return poppedEC;
    }

    protected void throwWarning(String message) {
        this.errorHandler.warning(new EXIException(String.valueOf(message) + ", options=" + this.exiFactory.getFidelityOptions()));
    }

    final class ElementContext {
        private String prefix;
        private String sqname;
        Grammar gr;
        List<NamespaceDeclaration> nsDeclarations;
        final QNameContext qnameContext;

        public ElementContext(QNameContext qnameContext, Grammar gr) {
            this.qnameContext = qnameContext;
            this.gr = gr;
        }

        String getQNameAsString() {
            if (this.sqname == null) {
                this.sqname = AbstractEXIBodyCoder.this.preservePrefix ? QNameUtilities.getQualifiedName(this.qnameContext.getLocalName(), this.getPrefix()) : this.qnameContext.getDefaultQNameAsString();
            }
            return this.sqname;
        }

        void setPrefix(String pfx) {
            this.prefix = pfx;
        }

        String getPrefix() {
            return this.prefix;
        }
    }
}

