/**
 * @author      ETSI / STF462 / Alexandre Berge
 * @version     $URL: $
 *              $Id: $
 */
package org.etsi.ttcn.codec.its.geonetworking;

import org.etsi.ttcn.codec.CodecBuffer;
import org.etsi.ttcn.codec.MainCodec;
import org.etsi.ttcn.codec.generic.Record;
import org.etsi.ttcn.tci.RecordValue;
import org.etsi.ttcn.tci.Type;
import org.etsi.ttcn.tci.Value;

public class GnIndReq extends Record {

    public GnIndReq(MainCodec mainCodec) {
        super(mainCodec);
    }

    @Override
    protected void preDecode(CodecBuffer buf, Type decodingHypothesis) {
//        TERFactory.getInstance().logDebug(">>> GnIndReq.preDecode: " + decodingHypothesis);
        
        int msgLen = buf.getNbBits() - 48 - 256/*SSP*/ - 32/*ItsAid*/;
        
        messageBuffer = buf.getBuffer(0, msgLen);
        macBuffer = buf.getBuffer(msgLen, 48);
        msgLen += 48;
        sspBuffer = buf.getBuffer(msgLen, 256/*SSP*/);
        msgLen += 256/*SSP*/;
        itsaidBuffer = buf.getBuffer(msgLen, 32/*ItsAid*/);
    }
    
    @Override
    protected void preDecodeField(String fieldName, CodecBuffer buf, Type decodingHypothesis, RecordValue rv) {
//        TERFactory.getInstance().logDebug(">>> GnIndReq.preDecodeField: " + fieldName + ", " + decodingHypothesis);

        if(fieldName.equals("macDestinationAddress")) {
            buf.overwriteWith(macBuffer);
        } else if(fieldName.equals("ssp")) {
            buf.overwriteWith(sspBuffer);
        } else if(fieldName.equals("its_aid")) {
            buf.overwriteWith(itsaidBuffer);
        }
        else {
            buf.overwriteWith(messageBuffer);
        }
    }

    @Override
    protected void postDecodeField(String fieldName, CodecBuffer buf, Type decodingHypothesis, RecordValue rv) {
//        TERFactory.getInstance().logDebug(">>> GnIndReq.postDecodeField: " + fieldName + ", " + decodingHypothesis);
        
    }
    
    @Override
    public CodecBuffer encode(Value value) {
//        TERFactory.getInstance().logDebug("GnIndReq.encode: " + value);

        return super.encode(value);
    }

    private CodecBuffer messageBuffer = null;
    private CodecBuffer macBuffer = null;
    private CodecBuffer sspBuffer = null;
    private CodecBuffer itsaidBuffer = null;
}
