package org.etsi.ttcn.codec.its.btp;

import org.etsi.ttcn.codec.MainCodec;
import org.etsi.ttcn.codec.generic.Union;

public class DecodedBtpPayload extends Union {
    
    public DecodedBtpPayload(MainCodec mainCodec) {
        super(mainCodec);
        setLengths();
    }
    
    private void setLengths() { // See LibItsBtp_TypesAndValues TTCN-3 module
        mainCodec.setHint("camPacket", "camPacket"); 
        mainCodec.setHint("denmPacket", "denmPacket"); 
        mainCodec.setHint("mapemPacket", "mapemPacket"); 
        mainCodec.setHint("spatemPacket", "spatemPacket"); 
        mainCodec.setHint("ivimPacket", "ivimPacket"); 
        mainCodec.setHint("evcsnPacket", "evcsnPacket"); 
        mainCodec.setHint("sremPacket", "sremPacket"); 
        mainCodec.setHint("ssemPacket", "ssemPacket"); 
    }
    
} // End of class DecodedBtpPayload 
