package org.etsi.ttcn.codec.its.adapter;

import org.etsi.ttcn.codec.CodecBuffer;
import org.etsi.ttcn.codec.MainCodec;
import org.etsi.ttcn.codec.generic.Boolean;
import org.etsi.ttcn.tci.Type;
import org.etsi.ttcn.tci.Value;

public class AcGnssResponse extends Boolean {

    private static final int AcGnssResponse = 0x02;

    public AcGnssResponse(MainCodec mainCodec) {
        super(mainCodec);
    }

    @Override
    public Value decode(CodecBuffer buf, Type decodingHypothesis) {
        
        byte[] readId = buf.readBytes(1);
        if(readId[0] != AcGnssResponse) {
            return null;
        }
        
        return super.decode(buf, decodingHypothesis);
    }
    
    @Override
    public CodecBuffer preEncode(Value value) {
        return new CodecBuffer(new byte[] {0x02});
    }

}
