#ifndef UpperTesterSremSsem_LAYER_H
#define UpperTesterSremSsem_LAYER_H

#include "TLayer.hh"
#include "UpperTesterSremSsemCodec.hh"

namespace LibItsSremSsem__TestSystem {
  class UpperTesterPort;
}

namespace LibItsSremSsem__TypesAndValues {
  class UtSremInitialize;
  class UtSremTrigger;
  class UtSremUpdate;
}

class UpperTesterSremSsemLayer : public TLayer<LibItsSremSsem__TestSystem::UpperTesterPort> {
  Params _params;
  UpperTesterSremSsemCodec _codec;
  
public:
  UpperTesterSremSsemLayer() : TLayer<LibItsSremSsem__TestSystem::UpperTesterPort>(), _params(), _codec() {};
  UpperTesterSremSsemLayer(const std::string & p_type, const std::string & param);
  virtual ~UpperTesterSremSsemLayer() {};

  void sendMsg(const LibItsSremSsem__TypesAndValues::UtSremInitialize& send_par, Params& params);
  void sendMsg(const LibItsSremSsem__TypesAndValues::UtSremTrigger& send_par, Params& params);
  void sendMsg(const LibItsSremSsem__TypesAndValues::UtSremUpdate& send_par, Params& params);
  
  virtual void sendData(OCTETSTRING& data, Params& params);
  virtual void receiveData(OCTETSTRING& data, Params& info);
};

#endif
