#include "UpperTesterSremSsemFactory.hh"

#include "UpperTesterTypes.hh"

#include "loggers.hh"

UpperTesterSremSsemLayer::UpperTesterSremSsemLayer(const std::string & p_type, const std::string & param) : TLayer<LibItsSremSsem__TestSystem::UpperTesterPort>(p_type), _params(), _codec() {
  loggers::get_instance().log(">>> UpperTesterSremSsemLayer::UpperTesterSremSsemLayer: %s, %s", to_string().c_str(), param.c_str());
  // Setup parameters
  Params::convert(_params, param);
}

void UpperTesterSremSsemLayer::sendMsg(const LibItsSremSsem__TypesAndValues::UtSremInitialize& send_par, Params& params){
  loggers::get_instance().log_msg(">>> UpperTesterSremSsemLayer::sendMsg", send_par);

  // Encode UpperTester PDU
  OCTETSTRING data;
  _codec.encode((const Record_Type &)send_par, data);
  // Update parameters
  sendData(data, params);
}

void UpperTesterSremSsemLayer::sendMsg(const LibItsSremSsem__TypesAndValues::UtSremTrigger& send_par, Params& params)
{
  loggers::get_instance().log_msg(">>> UpperTesterSremSsemLayer::sendMsg", send_par);

  // Encode UpperTester PDU
  OCTETSTRING data;
  _codec.encode(send_par, data);
  // Update parameters
  sendData(data, params);
}

void UpperTesterSremSsemLayer::sendMsg(const LibItsSremSsem__TypesAndValues::UtSremUpdate& send_par, Params& params)
{
  loggers::get_instance().log_msg(">>> UpperTesterSremSsemLayer::sendMsg", send_par);

  // Encode UpperTester PDU
  OCTETSTRING data;
  _codec.encode(send_par, data);
  // Update parameters
  sendData(data, params);
}

void UpperTesterSremSsemLayer::sendData(OCTETSTRING& data, Params& params) {
  loggers::get_instance().log_msg(">>> UpperTesterSremSsemLayer::sendData: ", data);
  //params.log();
  sendToAllLayers(data, params);
}

void UpperTesterSremSsemLayer::receiveData(OCTETSTRING& data, Params& params)
{
  loggers::get_instance().log_msg(">>> UpperTesterSremSsemLayer::receiveData: ", data);
 
  std::unique_ptr<Base_Type> r = _codec.decode(data);
  if (r.get() != nullptr) {
    // Pass it to the ports if amy
    toAllUpperPorts(*r, params);
  }
}

UpperTesterSremSsemFactory UpperTesterSremSsemFactory::_f;
