#include "UpperTesterMapemSpatemFactory.hh"

#include "UpperTesterTypes.hh"

#include "loggers.hh"

UpperTesterMapemSpatemLayer::UpperTesterMapemSpatemLayer(const std::string & p_type, const std::string & param) : TLayer<LibItsMapemSpatem__TestSystem::UpperTesterPort>(p_type), _params(), _codec() {
  loggers::get_instance().log(">>> UpperTesterMapemSpatemLayer::UpperTesterMapemSpatemLayer: %s, %s", to_string().c_str(), param.c_str());
  // Setup parameters
  Params::convert(_params, param);
}

void UpperTesterMapemSpatemLayer::sendMsg(const LibItsMapemSpatem__TypesAndValues::UtMapemSpatemInitialize& send_par, Params& params){
  loggers::get_instance().log_msg(">>> UpperTesterMapemSpatemLayer::sendMsg", send_par);

  // Encode UpperTester PDU
  OCTETSTRING data;
  _codec.encode((const Record_Type &)send_par, data);
  // Update parameters
  sendData(data, params);
}

void UpperTesterMapemSpatemLayer::sendMsg(const LibItsMapemSpatem__TypesAndValues::UtMapemSpatemTrigger& send_par, Params& params)
{
  loggers::get_instance().log_msg(">>> UpperTesterMapemSpatemLayer::sendMsg", send_par);

  // Encode UpperTester PDU
  OCTETSTRING data;
  _codec.encode(send_par, data);
  // Update parameters
  sendData(data, params);
}

void UpperTesterMapemSpatemLayer::sendData(OCTETSTRING& data, Params& params) {
  loggers::get_instance().log_msg(">>> UpperTesterMapemSpatemLayer::sendData: ", data);
  //params.log();
  sendToAllLayers(data, params);
}

void UpperTesterMapemSpatemLayer::receiveData(OCTETSTRING& data, Params& params)
{
  loggers::get_instance().log_msg(">>> UpperTesterMapemSpatemLayer::receiveData: ", data);
 
  std::unique_ptr<Base_Type> r = _codec.decode(data);
  if (r.get() != nullptr) {
    // Pass it to the ports if amy
    toAllUpperPorts(*r, params);
  }
}

UpperTesterMapemSpatemFactory UpperTesterMapemSpatemFactory::_f;
