/*!
 * \file      UpperTesterIvimFactory.hh
 * \brief     Header file for ITS IVIM Upper Tester protocol layer factory.
 * \author    ETSI STF525
 * \copyright ETSI Copyright Notification
 *            No part may be reproduced except as authorized by written permission.
 *            The copyright and the foregoing restriction extend to reproduction in all media.
 *            All rights reserved.
 * \version   0.1
 */
#pragma once

#include "LayerStackBuilder.hh"

#include "UpperTesterIvimLayer.hh"

class UpperTesterIvimFactory : public LayerFactory {
  static UpperTesterIvimFactory _f;
public:
  UpperTesterIvimFactory() {
    // Register factory
    LayerStackBuilder::RegisterLayerFactory("UT_IVIM", this);
  };
  inline virtual Layer * createLayer(const std::string& p_type, const std::string& p_param){
    return new UpperTesterIvimLayer(p_type, p_param);
  };
}; // End of class UpperTesterIvimFactory
