#ifndef UpperTesterGn_LAYER_H
#define UpperTesterGn_LAYER_H

#include "TLayer.hh"
#include "UpperTesterGnCodec.hh"

namespace LibItsGeoNetworking__TestSystem {
  class UpperTesterPort;
}

namespace LibItsGeoNetworking__TypesAndValues {
  class UtGnInitialize;
  class UtGnChangePosition;
  class UtGnTrigger;
  class UtAutoInteropTrigger;
}

class UpperTesterGnLayer : public TLayer<LibItsGeoNetworking__TestSystem::UpperTesterPort> {
  Params _params;
  UpperTesterGnCodec _codec;
  
public:
  UpperTesterGnLayer() : TLayer<LibItsGeoNetworking__TestSystem::UpperTesterPort>(), _params(), _codec() {};
  UpperTesterGnLayer(const std::string & p_type, const std::string & param);
  virtual ~UpperTesterGnLayer() {};

  void sendMsg(const LibItsGeoNetworking__TypesAndValues::UtGnInitialize& send_par, Params& params);
  void sendMsg(const LibItsGeoNetworking__TypesAndValues::UtGnChangePosition& send_par, Params& params);
  void sendMsg(const LibItsGeoNetworking__TypesAndValues::UtGnTrigger& send_par, Params& params);
  void sendMsg(const LibItsGeoNetworking__TypesAndValues::UtAutoInteropTrigger& send_par, Params& params);
  
  virtual void sendData(OCTETSTRING& data, Params& params);
  virtual void receiveData(OCTETSTRING& data, Params& info);
};

#endif
