#include "UpperTesterDenmFactory.hh"

#include "UpperTesterTypes.hh"

#include "loggers.hh"

UpperTesterDenmLayer::UpperTesterDenmLayer(const std::string & p_type, const std::string & param) : TLayer<LibItsDenm__TestSystem::UpperTesterPort>(p_type), _params(), _codec() {
  loggers::get_instance().log(">>> UpperTesterDenmLayer::UpperTesterDenmLayer: %s, %s", to_string().c_str(), param.c_str());
  // Setup parameters
  Params::convert(_params, param);
}

void UpperTesterDenmLayer::sendMsg(const LibItsDenm__TypesAndValues::UtDenmInitialize& send_par, Params& params){
  loggers::get_instance().log_msg(">>> UpperTesterDenmLayer::sendMsg", send_par);

  // Encode UpperTester PDU
  OCTETSTRING data;
  _codec.encode((const Record_Type &)send_par, data);
  // Update parameters
  sendData(data, params);
}

void UpperTesterDenmLayer::sendMsg(const LibItsDenm__TypesAndValues::UtDenmChangePosition& send_par, Params& params)
{
  loggers::get_instance().log_msg(">>> UpperTesterDenmLayer::sendMsg", send_par);

  // Encode UpperTester PDU
  OCTETSTRING data;
  _codec.encode((const Record_Type &)send_par, data);
  // Update parameters
  sendData(data, params);
}

void UpperTesterDenmLayer::sendMsg(const LibItsDenm__TypesAndValues::UtDenmChangePseudonym& send_par, Params& params)
{
  loggers::get_instance().log_msg(">>> UpperTesterDenmLayer::sendMsg", send_par);

  // Encode UpperTester PDU
  OCTETSTRING data;
  _codec.encode((const Record_Type &)send_par, data);
  // Update parameters
  sendData(data, params);
}

void UpperTesterDenmLayer::sendMsg(const LibItsDenm__TypesAndValues::UtDenmTrigger& send_par, Params& params)
{
  loggers::get_instance().log_msg(">>> UpperTesterDenmLayer::sendMsg", send_par);

  // Encode UpperTester PDU
  OCTETSTRING data;
  _codec.encode((const Record_Type &)send_par, data);
  // Update parameters
  sendData(data, params);
}

void UpperTesterDenmLayer::sendMsg(const LibItsDenm__TypesAndValues::UtDenmUpdate& send_par, Params& params)
{
  loggers::get_instance().log_msg(">>> UpperTesterDenmLayer::sendMsg", send_par);

  // Encode UpperTester PDU
  OCTETSTRING data;
  _codec.encode((const Record_Type &)send_par, data);
  // Update parameters
  sendData(data, params);
}

void UpperTesterDenmLayer::sendMsg(const LibItsDenm__TypesAndValues::UtDenmTermination& send_par, Params& params)
{
  loggers::get_instance().log_msg(">>> UpperTesterDenmLayer::sendMsg", send_par);

  // Encode UpperTester PDU
  OCTETSTRING data;
  _codec.encode((const Record_Type &)send_par, data);
  // Update parameters
  sendData(data, params);
}

void UpperTesterDenmLayer::sendData(OCTETSTRING& data, Params& params) {
  loggers::get_instance().log_msg(">>> UpperTesterDenmLayer::sendData: ", data);
  //params.log();
  sendToAllLayers(data, params);
}

void UpperTesterDenmLayer::receiveData(OCTETSTRING& data, Params& params)
{
  loggers::get_instance().log_msg(">>> UpperTesterDenmLayer::receiveData: ", data);
 
  std::unique_ptr<Base_Type> r = _codec.decode(data);
  if (r.get() != nullptr) {
    // Pass it to the ports if amy
    toAllUpperPorts(*r, params);
  }
}

UpperTesterDenmFactory UpperTesterDenmFactory::_f;
