#ifndef UpperTesterCam_LAYER_H
#define UpperTesterCam_LAYER_H

#include <memory>

#include "TLayer.hh"
#include "UpperTesterCamCodec.hh"

namespace LibItsCam__TestSystem {
  class UpperTesterPort;
}

namespace LibItsCam__TypesAndValues {
  class UtCamInitialize;
  class UtCamChangePosition;
  class UtCamTrigger;
}

class UpperTesterCamLayer : public TLayer<LibItsCam__TestSystem::UpperTesterPort> {
  Params _params;
  UpperTesterCamCodec _codec;
  
public:
  UpperTesterCamLayer() : TLayer<LibItsCam__TestSystem::UpperTesterPort>(), _params(), _codec() {};
  UpperTesterCamLayer(const std::string & p_type, const std::string & param);
  virtual ~UpperTesterCamLayer() {};

  void sendMsg(const LibItsCam__TypesAndValues::UtCamInitialize& send_par, Params& params);
  void sendMsg(const LibItsCam__TypesAndValues::UtCamChangePosition& send_par, Params& params);
  void sendMsg(const LibItsCam__TypesAndValues::UtCamTrigger& send_par, Params& params);
  
  virtual void sendData(OCTETSTRING& data, Params& params);
  virtual void receiveData(OCTETSTRING& data, Params& info);
};

#endif
