/*!
 * \file      UdpLayerFactory.hh
 * \brief     Header file for ITS IP/UDP protocol layer factory.
 * \author    ETSI STF525
 * \copyright ETSI Copyright Notification
 *            No part may be reproduced except as authorized by written permission.
 *            The copyright and the foregoing restriction extend to reproduction in all media.
 *            All rights reserved.
 * \version   0.1
 */
#pragma once

#include "LayerStackBuilder.hh"

#include "UdpLayer.hh"

class UdpLayerFactory: public LayerFactory {
  static UdpLayerFactory _f;
public:
  UdpLayerFactory() {
        // register factory
        LayerStackBuilder::RegisterLayerFactory("UDP", this);
      };
  virtual Layer * createLayer(const std::string& p_type, const std::string& p_param) {
        return new UdpLayer(p_type, p_param);
      };
}; // End of class UdpLayerFactory
