#ifndef UDP_LAYER_H
#define UDP_LAYER_H

#include <arpa/inet.h>
#if !defined(LINUX)
#include <netdb.h>
#include <w32api/winsock2.h>
/*struct iphdr {
    #if defined(__LITTLE_ENDIAN_BITFIELD)
        u_char    ihl:4,
                version:4;
    #elif defined (__BIG_ENDIAN_BITFIELD)
        u_char    version:4,
                ihl:4;
    #else
        #error  "Please fix <asm/byteorder.h>"
    #endif
        u_char   tos;
        u_short  tot_len;
        u_short  id;
        u_short  frag_off;
         u_char   ttl;
         u_char   protocol;
         u_short  check;
         u_int  saddr;
         u_int  daddr;
         //The options start here.
};*/
#else // LINUX
#include <linux/ip.h>
#include <linux/udp.h>
#endif // LINUX

#include "TLayer.hh"
#include "Params.hh"

class UdpLayer : public Layer {
  Params _params;
  struct iphdr* _iphdr;
  struct udphdr* _udphdr;
  struct sockaddr_in _saddr;
  struct sockaddr_in _daddr;

  unsigned short inet_check_sum(const void *buf, size_t hdr_len, const unsigned short p_initial_sum = 0);

public:
  UdpLayer(const std::string & p_type, const std::string & param);
  virtual ~UdpLayer() {}

  virtual void sendData(OCTETSTRING& data, Params& params);
  virtual void receiveData(OCTETSTRING& data, Params& info);
};

#endif
