/*!
 * \file      SremSsemLayerFactory.hh
 * \brief     Header file for ITS SremSsem protocol layer factory.
 * \author    ETSI STF525
 * \copyright ETSI Copyright Notification
 *            No part may be reproduced except as authorized by written permission.
 *            The copyright and the foregoing restriction extend to reproduction in all media.
 *            All rights reserved.
 * \version   0.1
 */
#pragma once

#include "LayerStackBuilder.hh"

#include "SremSsemLayer.hh"

class SremSsemLayerFactory : public LayerFactory {
  static SremSsemLayerFactory _f;
public:
  SremSsemLayerFactory() {
    // Register factory
    LayerStackBuilder::RegisterLayerFactory("SremSsem", this);
  };
  inline virtual Layer * createLayer(const std::string& p_type, const std::string& p_param){
    return new SremSsemLayer(p_type, p_param);
  };
}; // End of class SremSsemLayerFactory

