/*!
 * \file      SremSsemLayer.hh
 * \brief     Header file for ITS SremSsem protocol layer.
 * \author    ETSI STF525
 * \copyright ETSI Copyright Notification
 *            No part may be reproduced except as authorized by written permission.
 *            The copyright and the foregoing restriction extend to reproduction in all media.
 *            All rights reserved.
 * \version   0.1
 */
#pragma once

#include "TLayer.hh"
#include "SremCodec.hh"
#include "SsemCodec.hh"

namespace LibItsSremSsem__TestSystem {
  class SremSsemPort;
  class SremReq;
  class SremInd;
  class SsemReq;
  class SsemInd;
}

class SremSsemLayer : public TLayer<LibItsSremSsem__TestSystem::SremSsemPort> {
  Params _params;
  SremCodec _srem_codec;
  SsemCodec _ssem_codec;
public:
  SremSsemLayer() : TLayer<LibItsSremSsem__TestSystem::SremSsemPort>(), _params(), _srem_codec(), _ssem_codec() {};
  SremSsemLayer(const std::string& p_type, const std::string& param);
  virtual ~SremSsemLayer() {};

  void sendMsg(const LibItsSremSsem__TestSystem::SremReq&, Params& params);
  void sendMsg(const LibItsSremSsem__TestSystem::SsemReq&, Params& params);
  
  virtual void sendData(OCTETSTRING& data, Params& params);
  virtual void receiveData(OCTETSTRING& data, Params& info);
}; // End of class SremSsemLayer

