#include "SremSsemTypes.hh"

#include "SremSsemLayerFactory.hh"

#include "loggers.hh"

SremSsemLayer::SremSsemLayer(const std::string & p_type, const std::string & param) : TLayer<LibItsSremSsem__TestSystem::SremSsemPort>(p_type), _params(), _srem_codec(), _ssem_codec() {
  loggers::get_instance().log(">>> SremSsemLayer::SremSsemLayer: %s, %s", to_string().c_str(), param.c_str());
  // Setup parameters
  Params::convert(_params, param);
}

void SremSsemLayer::sendMsg(const LibItsSremSsem__TestSystem::SremReq& p, Params& params){
  loggers::get_instance().log_msg(">>> SremSsemLayer::sendMsg: ", p);

  // Encode srem PDU
  OCTETSTRING data;
  if (_srem_codec.encode(p.msgOut(), data) == -1) {
    loggers::get_instance().warning("SremSsemLayer::sendMsg: Encodeing failure");
    return;
  }
  sendData(data, params);
}

void SremSsemLayer::sendMsg(const LibItsSremSsem__TestSystem::SsemReq& p, Params& params){
  loggers::get_instance().log_msg(">>> ssemLayer::sendMsg: ", p);

  // Encode ssem PDU
  OCTETSTRING data;
  if (_ssem_codec.encode(p.msgOut(), data) == -1) {
    loggers::get_instance().warning("SremSsemLayer::sendMsg: Encodeing failure");
    return;
  }
  sendData(data, params);
}

void SremSsemLayer::sendData(OCTETSTRING& data, Params& params) {
  loggers::get_instance().log_msg(">>> SremSsemLayer::sendData: ", data);
  //params.log();
  sendToAllLayers(data, params);
}

void SremSsemLayer::receiveData(OCTETSTRING& data, Params& params)
{
  loggers::get_instance().log_msg(">>> SremSsemLayer::receiveData: ", data);
  
  // Sanity check
  if (*(static_cast<const unsigned char*>(data)+ 1) == 0x09) { // Check that received packet has SRE message id 
    // Decode the SREM payload
    LibItsSremSsem__TestSystem::SremInd p;
    _srem_codec.decode(data, p.msgIn());
    if (!p.msgIn().is_bound()) {
      // Discard it
      return;
    } // else, continue
  } else if (*(static_cast<const unsigned char*>(data)+ 1) == 0x0A) { // Check that received packet has SSE message id 
    // Decode the SSEM payload
    LibItsSremSsem__TestSystem::SsemInd p;
    _ssem_codec.decode(data, p.msgIn());
    if (!p.msgIn().is_bound()) {
      // Discard it
      return;
    } // else, continue
  } else {
    // Not a DENM message, discard it
    loggers::get_instance().warning("SremSsemLayer::receiveData: Wrong message id: 0x%02x", *(static_cast<const unsigned char*>(data)+ 1));
    return;
  }

  /*
  // TODOProcess lower layer data
  // gnNextHeader
  Params::const_iterator it = params.find(Params::gn_next_header);
  if (it != params.cend()) {
    p.gnNextHeader() = std::stoi(it->second);
  } else {
    p.gnNextHeader().set_to_omit();
  }
  // gnHeaderType
  it = params.find(Params::gn_header_type);
  if (it != params.cend()) {
    p.gnHeaderType() = std::stoi(it->second);
  } else {
    p.gnHeaderType().set_to_omit();
  }
  // gnHeaderSubtype
  it = params.find(Params::gn_header_sub_type);
  if (it != params.cend()) {
    p.gnHeaderSubtype() = std::stoi(it->second);
  } else {
    p.gnHeaderSubtype().set_to_omit();
  }
  // gnLifetime
  it = params.find(Params::gn_lifetime);
  if (it != params.cend()) {
    p.gnLifetime() = std::stoi(it->second);
  } else {
    p.gnLifetime().set_to_omit();
  }
  // gnTrafficClass
  it = params.find(Params::gn_traffic_class);
  if (it != params.cend()) {
    p.gnTrafficClass() = std::stoi(it->second);
  } else {
    p.gnTrafficClass().set_to_omit();
  }
  // btpDestinationPort
  it = params.find(Params::btp_destination_port);
  if (it != params.cend()) {
    p.btpDestinationPort() = std::stoi(it->second);
  } else {
    p.btpDestinationPort().set_to_omit();
  }
  // btpInfo
  it = params.find(Params::btp_info);
  if (it != params.cend()) {
    p.btpInfo() = std::stoi(it->second);
  } else {
    p.btpInfo().set_to_omit();
  }
  // ssp
  it = params.find(Params::ssp);
  if (it != params.cend()) {
    OCTETSTRING os(it->second.length(), (const unsigned char *)(it->second.c_str()));
    p.ssp() = oct2bit(os);
  } else {
    p.ssp().set_to_omit();
  }
  // its_aid
  it = params.find(Params::its_aid);
  if (it != params.cend()) {
    p.its__aid() = std::stoi(it->second);
  } else {
    p.its__aid().set_to_omit();
  }
  
  // Pass it to the ports if amy
  toAllUpperPorts(p, params);*/
}

SremSsemLayerFactory SremSsemLayerFactory::_f;
