#ifndef SREMCODEC_H
#define SREMCODEC_H

#include "Codec.hh"
#include "PERCodec.hh"
#include "Params.hh"

#include "LibItsSremSsem_TestSystem.hh"

class SremPDUCodec : public PERCodec <SREM__PDU__Descriptions::SREM>
{
public:
  SremPDUCodec() { };
  virtual int encode (const SREM__PDU__Descriptions::SREM& srem, BITSTRING& data);
  virtual int decode (const BITSTRING& data, SREM__PDU__Descriptions::SREM&);
};

class SremCodec : public Codec<SREM__PDU__Descriptions::SREM, SREM__PDU__Descriptions::SREM>
{
  SremPDUCodec asnCodec;

public:
  SremCodec() : Codec<SREM__PDU__Descriptions::SREM, SREM__PDU__Descriptions::SREM>(), asnCodec() { };
  virtual ~SremCodec() { };

  virtual int encode (const SREM__PDU__Descriptions::SREM& srem, OCTETSTRING& data);
  virtual int decode (const OCTETSTRING& data, SREM__PDU__Descriptions::SREM&, Params* params = NULL);
};

#endif
