#pragma once

#include <vector>

#include <openssl/sha.h>
#include <openssl/objects.h>

class sha384 {
  SHA512_CTX _ctx;
public:
  explicit sha384(): _ctx{} { };
  virtual ~sha384() { };

  inline int generate(const std::vector<unsigned char> p_buffer, std::vector<unsigned char>& p_hash) {
    // Sanity check
    if (p_buffer.size() == 0) {
      return -1;
    }

    return generate(p_buffer.data(), p_buffer.size(), p_hash);
  };
  
  inline int generate(const unsigned char *p_buffer, const size_t p_length, std::vector<unsigned char>& p_hash) {
    // Sanity check
    if (p_buffer == nullptr) {
      return -1;
    }
    // Resize data buffer
    p_hash.resize(SHA384_DIGEST_LENGTH);
    // Compute the hash value
    ::SHA384_Init(&_ctx);
    ::SHA384_Update(&_ctx, p_buffer, p_length);
    ::SHA384_Final(static_cast<unsigned char*>(p_hash.data()), &_ctx);
    return 0;
  };
}; // End of class sha384
