#pragma once

#include "security_cache.hh"

/*!
 * \class security_db
 * \brief This class provides security record description for security database
 */
class security_db : public security_cache {
  
public: /*! \publicsection */
  /*!
   * \brief Ctor with full path to the certificates storage
   */
  security_db(const std::string& p_db_path);
  /*!
   * \brief Default private dtor
   */
  ~security_db();

  int store_certificate(const CHARSTRING& p_cert_id, const OCTETSTRING& p_cert, const OCTETSTRING& p_private_key, const OCTETSTRING& p_public_key_x, const OCTETSTRING& p_public_key_y, const OCTETSTRING& p_hashid8, const OCTETSTRING& p_issuer);
  int clear();

private:
  int load_from_files(const std::string& p_db_path);
}; // End of class security_db
