/*!
 * \file      RawSocketLayerFactory.hh
 * \brief     Header file for ITS Raw socket layer factory.
 * \author    ETSI STF525
 * \copyright ETSI Copyright Notification
 *            No part may be reproduced except as authorized by written permission.
 *            The copyright and the foregoing restriction extend to reproduction in all media.
 *            All rights reserved.
 * \version   0.1
 */
#pragma once

#include "LayerStackBuilder.hh"

#include "RawSocketLayer.hh"

class RawSocketLayerFactory: public LayerFactory {
  static RawSocketLayerFactory _f;
public:
  RawSocketLayerFactory() {
    // register factory
    LayerStackBuilder::RegisterLayerFactory("RAW", this);
  };

  inline virtual Layer * createLayer(const std::string& p_type, const std::string& p_param) {
    return new RawSocketLayer(p_type, p_param);
  };
}; // End of class RawSocketLayerFactory

