/*!
 * \file      PcapLayerFactory.hh
 * \brief     Header file for Pcap layer factory.
 * \author    ETSI STF525
 * \copyright ETSI Copyright Notification
 *            No part may be reproduced except as authorized by written permission.
 *            The copyright and the foregoing restriction extend to reproduction in all media.
 *            All rights reserved.
 * \version   0.1
 */
#pragma once

#if (OSTYPE == linux)

#include "LayerStackBuilder.hh"

#include "PcapLayer.hh"

class PcapLayerFactory: public LayerFactory {
  static PcapLayerFactory _f;
public:
  PcapLayerFactory() {
    // register factory
    LayerStackBuilder::RegisterLayerFactory("PCAP", this);
  };
  inline virtual Layer * createLayer(const std::string& p_type, const std::string& p_param) {
    return new PcapLayer(p_type, p_param);
  };
}; // End of class PcapLayerFactory

#endif

