/*!
 * \file      PcapLayer.hh
 * \brief     Header file for ITS Pcap layer.
 * \author    ETSI STF525
 * \copyright ETSI Copyright Notification
 *            No part may be reproduced except as authorized by written permission.
 *            The copyright and the foregoing restriction extend to reproduction in all media.
 *            All rights reserved.
 * \version   0.1
 */
#pragma once

#if (OSTYPE == linux)

#include <thread>
#include <mutex>
#include <pcap/pcap.h>

#include "TLayer.hh"
#include "Params.hh"

class PORT;

class PcapLayer : public Layer, public PORT {
  Params _params;
  pcap_t* _device;
  int _pcap_h;
  std::thread* _thread;
  bool _running;
  std::mutex _resume;
  pcap_dumper_t* _sent_file;
  std::string _time_key;
  int _fd[2];

  static void* run(void* p_this);
public:
  PcapLayer(const std::string& p_type, const std::string& param);
  virtual ~PcapLayer();

  virtual void sendData(OCTETSTRING& data, Params& params);
  virtual void receiveData(OCTETSTRING& data, Params& info);
  
  void Handle_Fd_Event_Readable(int fd);
};

#endif
