#ifndef MAPEMCODEC_H
#define MAPEMCODEC_H

#include "Codec.hh"
#include "PERCodec.hh"
#include "Params.hh"

#include "LibItsMapemSpatem_TestSystem.hh"

class MapemPDUCodec : public PERCodec <MAPEM__PDU__Descriptions::MAPEM>
{
public:
  MapemPDUCodec() { };
  virtual int encode (const MAPEM__PDU__Descriptions::MAPEM& sapem, BITSTRING& data);
  virtual int decode (const BITSTRING& data, MAPEM__PDU__Descriptions::MAPEM&);
};

class MapemCodec : public Codec<MAPEM__PDU__Descriptions::MAPEM, MAPEM__PDU__Descriptions::MAPEM>
{
  MapemPDUCodec asnCodec;

public:
  MapemCodec() : Codec<MAPEM__PDU__Descriptions::MAPEM, MAPEM__PDU__Descriptions::MAPEM>(), asnCodec() { };
  virtual ~MapemCodec() { };

  virtual int encode (const MAPEM__PDU__Descriptions::MAPEM& sapem, OCTETSTRING& data);
  virtual int decode (const OCTETSTRING& data, MAPEM__PDU__Descriptions::MAPEM&, Params* params = NULL);
};

#endif
