/*!
 * \file      IVIMLayer.hh
 * \brief     Header file for ITS IVIM protocol layer.
 * \author    ETSI STF525
 * \copyright ETSI Copyright Notification
 *            No part may be reproduced except as authorized by written permission.
 *            The copyright and the foregoing restriction extend to reproduction in all media.
 *            All rights reserved.
 * \version   0.1
 */
#pragma once

#include "TLayer.hh"
#include "IVIMCodec.hh"

namespace LibItsIvim__TestSystem {
  class IvimPort;
  class IvimReq;
  class IvimInd;
}

class IVIMLayer : public TLayer<LibItsIvim__TestSystem::IvimPort> {
  Params _params;
  IVIMCodec _codec;
public:
  IVIMLayer() : TLayer<LibItsIvim__TestSystem::IvimPort>(), _params(), _codec() {};
  IVIMLayer(const std::string& p_type, const std::string& param);
  virtual ~IVIMLayer() {};

  void sendMsg(const LibItsIvim__TestSystem::IvimReq&, Params& params);
    
  virtual void sendData(OCTETSTRING& data, Params& params);
  virtual void receiveData(OCTETSTRING& data, Params& info);
}; // End of class IVIMLayer

