#ifndef IVIMCODEC_H
#define IVIMCODEC_H

#include "Codec.hh"
#include "PERCodec.hh"
#include "Params.hh"

#include "LibItsIvim_TestSystem.hh"
//class BITSTRING;
//class OCTETSTRING;
//class IVIM__PDU__Descriptions::IVIM;

class IVIMPDUCodec : public PERCodec <IVIM__PDU__Descriptions::IVIM>
{
public:
  IVIMPDUCodec() { };
  virtual int encode (const IVIM__PDU__Descriptions::IVIM& ivim, BITSTRING& data);
  virtual int decode (const BITSTRING& data, IVIM__PDU__Descriptions::IVIM&);
};

class IVIMCodec : public Codec<IVIM__PDU__Descriptions::IVIM, IVIM__PDU__Descriptions::IVIM>
{
  IVIMPDUCodec asnCodec;

public:
  IVIMCodec() : Codec<IVIM__PDU__Descriptions::IVIM, IVIM__PDU__Descriptions::IVIM>(), asnCodec() { };
  virtual ~IVIMCodec() { };

  virtual int encode (const IVIM__PDU__Descriptions::IVIM& ivim, OCTETSTRING& data);
  virtual int decode (const OCTETSTRING& data, IVIM__PDU__Descriptions::IVIM&, Params* params = NULL);
};

#endif
