/*!
 * \file      GeoNetworkingLayerFactory.hh
 * \brief     Header file for ITS GeoNetworking protocol layer factory.
 * \author    ETSI STF525
 * \copyright ETSI Copyright Notification
 *            No part may be reproduced except as authorized by written permission.
 *            The copyright and the foregoing restriction extend to reproduction in all media.
 *            All rights reserved.
 * \version   0.1
 */
#pragma once

#include "LayerStackBuilder.hh"

#include "GeoNetworkingLayer.hh"

class GeoNetworkingLayerFactory: public LayerFactory {
  static GeoNetworkingLayerFactory _f;
public:
  GeoNetworkingLayerFactory() {
    // Register factory
    LayerStackBuilder::RegisterLayerFactory("GN", this);
  };

  inline virtual Layer * createLayer(const std::string& p_type, const std::string& p_param) {
    return new GeoNetworkingLayer(p_type, p_param);
  };

}; // End of class GeoNetworkingLayerFactory

