/*!
 * \file      EthernetLayerFactory.hh
 * \brief     Header file for ITS Ethernet protocol layer factory.
 * \author    ETSI STF525
 * \copyright ETSI Copyright Notification
 *            No part may be reproduced except as authorized by written permission.
 *            The copyright and the foregoing restriction extend to reproduction in all media.
 *            All rights reserved.
 * \version   0.1
 */
#pragma once

#include "LayerStackBuilder.hh"

#include "EthernetLayer.hh"

class EthernetLayerFactory: public LayerFactory {
  static EthernetLayerFactory _f;
public:
  EthernetLayerFactory() {
    // register factory
    LayerStackBuilder::RegisterLayerFactory("ETH", this);
  };

  inline virtual Layer * createLayer(const std::string& p_type, const std::string& p_param) {
    return new EthernetLayer(p_type, p_param);
  };
}; // End of class EthernetLayerFactory

