/*!
 * \file      DENMLayer.hh
 * \brief     Header file for ITS DENM protocol layer.
 * \author    ETSI STF525
 * \copyright ETSI Copyright Notification
 *            No part may be reproduced except as authorized by written permission.
 *            The copyright and the foregoing restriction extend to reproduction in all media.
 *            All rights reserved.
 * \version   0.1
 */
#pragma once

#include "TLayer.hh"
#include "DENMCodec.hh"

namespace LibItsDenm__TestSystem {
  class DenmPort;
  class DenmReq;
  class DenmInd;
}

class DENMLayer : public TLayer<LibItsDenm__TestSystem::DenmPort> {
  Params _params;
  DENMCodec _codec;
public:
  DENMLayer() : TLayer<LibItsDenm__TestSystem::DenmPort>(), _params(), _codec() {};
  DENMLayer(const std::string& p_type, const std::string& param);
  virtual ~DENMLayer() {};

  void sendMsg(const LibItsDenm__TestSystem::DenmReq& p, Params& params);
    
  virtual void sendData(OCTETSTRING& data, Params& params);
  virtual void receiveData(OCTETSTRING& data, Params& info);
}; // End of class DENMLayer

