#include "LibItsDenm_TestSystem.hh"
#include "DENMCodec.hh"
#include "asn1/asn_application.h" // from asn1c
#include "loggers.hh"

int DENMCodec::encode (const DENM__PDU__Descriptions::DENM& p_denm, OCTETSTRING& p_data)
{
  loggers::get_instance().log_msg(">>> DENMCodec::encode: ", p_denm);
  
  BITSTRING b;
  int rc = asnCodec.encode(p_denm, b);
  if(rc){
    p_data = bit2oct(b);
  }
  loggers::get_instance().log("<<< DENMCodec::encode: %d", rc);
  return rc;
}

int DENMCodec::decode (const OCTETSTRING& p_data, DENM__PDU__Descriptions::DENM& p_denm, Params* params)
{
  loggers::get_instance().log_msg(">>> DENMCodec::decode:", p_data);
  
  int rc = asnCodec.decode(oct2bit(p_data), p_denm);
  loggers::get_instance().log("DENMCodec::decode: ASN.1 codec returned %d", rc);
  if(rc) {
    loggers::get_instance().log_msg("DENMCodec::decode: ", p_denm);
  }
  return rc;
}

extern "C" {
  extern asn_TYPE_descriptor_t asn_DEF_DENM;
}

int DENMPDUCodec::encode (const DENM__PDU__Descriptions::DENM& p_denm, BITSTRING& p_data)
{
  return _encode(DENM__PDU__Descriptions::DENM_descr_, asn_DEF_DENM, p_denm, p_data);
}

int DENMPDUCodec::decode (const BITSTRING& p_data, DENM__PDU__Descriptions::DENM& p_denm)
{
  return _decode(DENM__PDU__Descriptions::DENM_descr_, asn_DEF_DENM, p_data, p_denm);
}
