#pragma once

#include "TLayer.hh"
#include "Params.hh"

class OCTETSTRING;

class CommsigniaLayer : public Layer {
  static constexpr unsigned char LL_ADDR_LENGTH = 6;
  static constexpr unsigned char LL_ORG_CODE_LENGTH = 3;
  
  typedef struct {
    unsigned char version;
    unsigned int timestamp_sec;
    unsigned int timestamp_msec;
    unsigned char primary_channel;
    unsigned char secondary_channel;
    unsigned char used_iface;
    unsigned char data_rate;
    unsigned char antenna;
    unsigned int latitude;
    unsigned int longitude;
    unsigned short speed;
    unsigned short heading;
    unsigned char rssi_ant1;
    unsigned char rssi_ant2;
    unsigned char noise_ant1;
    unsigned char noise_ant2;
    unsigned short cbr_ant1;
    unsigned short cbr_ant2;
  } __attribute__((__packed__)) c2p_recv;

  typedef struct {
    unsigned short frame_ctrl;
    unsigned short duration;
    unsigned char dst_addr[CommsigniaLayer::LL_ADDR_LENGTH];
    unsigned char src_addr[CommsigniaLayer::LL_ADDR_LENGTH];
    unsigned char bss_id[CommsigniaLayer::LL_ADDR_LENGTH];
    unsigned short fragment_seq_num;
  } __attribute__((__packed__)) c2p_802_11p_hdr;

  typedef unsigned short c2p_qos_ctrl;
  
  typedef struct {
    unsigned char dsap;
    unsigned char ssap;
    unsigned char ctrl;
    unsigned char org_code[CommsigniaLayer::LL_ORG_CODE_LENGTH];
    unsigned short type;
  } __attribute__((__packed__)) c2p_llc_hdr;

  Params _params;

  c2p_recv _c2p_recv;
  c2p_802_11p_hdr _802_11p_hdr;
  c2p_llc_hdr _c2p_llc_hdr;
  std::vector<unsigned char> _mac_src; //! Used to optimize filtering on source mac address in \see CommsigniaLayer::receiveData method
  std::vector<unsigned char> _eth_type; //! Used to optimize filtering on ethernet type in \see CommsigniaLayer::receiveData method
  
public:
  CommsigniaLayer(const std::string & p_type, const std::string & param);
  virtual ~CommsigniaLayer() {};

  virtual void sendData(OCTETSTRING& data, Params& params);
  virtual void receiveData(OCTETSTRING& data, Params& info);
}; // End of class CommsigniaLayer
