/*!
 * \file      CAMLayerFactory.hh
 * \brief     Header file for ITS CAM protocol layer factory.
 * \author    ETSI STF525
 * \copyright ETSI Copyright Notification
 *            No part may be reproduced except as authorized by written permission.
 *            The copyright and the foregoing restriction extend to reproduction in all media.
 *            All rights reserved.
 * \version   0.1
 */
#pragma once

#include "LayerStackBuilder.hh"

#include "CAMLayer.hh"

class CAMLayerFactory : public LayerFactory {
  static CAMLayerFactory _f;
public:
  CAMLayerFactory() {
    // Register factory
    LayerStackBuilder::RegisterLayerFactory("CAM", this);
  };
  inline virtual Layer * createLayer(const std::string& p_type, const std::string& p_param){
    return new CAMLayer(p_type, p_param);
  };
}; // End of class CAMLayerFactory

