/*!
 * \file      CAMLayer.hh
 * \brief     Header file for ITS CAM protocol layer.
 * \author    ETSI STF525
 * \copyright ETSI Copyright Notification
 *            No part may be reproduced except as authorized by written permission.
 *            The copyright and the foregoing restriction extend to reproduction in all media.
 *            All rights reserved.
 * \version   0.1
 */
#pragma once

#include "TLayer.hh"
#include "CAMCodec.hh"

namespace LibItsCam__TestSystem {
  class CamPort;
  class CamReq;
  class CamInd;
}

class CAMLayer : public TLayer<LibItsCam__TestSystem::CamPort> {
  Params _params;
  CAMCodec _codec;
public:
  CAMLayer() : TLayer<LibItsCam__TestSystem::CamPort>(), _params(), _codec() {};
  CAMLayer(const std::string& p_type, const std::string& param);
  virtual ~CAMLayer() {};

  void sendMsg(const LibItsCam__TestSystem::CamReq&, Params& params);
    
  virtual void sendData(OCTETSTRING& data, Params& params);
  virtual void receiveData(OCTETSTRING& data, Params& info);
}; // End of class CAMLayer

