/*!
 * \file      BTPLayerFactory.hh
 * \brief     Header file for ITS BTP protocol layer factory.
 * \author    ETSI STF525
 * \copyright ETSI Copyright Notification
 *            No part may be reproduced except as authorized by written permission.
 *            The copyright and the foregoing restriction extend to reproduction in all media.
 *            All rights reserved.
 * \version   0.1
 */
#pragma once

#include "LayerStackBuilder.hh"

#include "BTPLayer.hh"

class BTPLayerFactory : public LayerFactory {
  static BTPLayerFactory _f;
public:
  BTPLayerFactory() {
    // Register factory
    LayerStackBuilder::RegisterLayerFactory("BTP", this);
  };
  inline virtual Layer * createLayer(const std::string& p_type, const std::string& p_param){
    return new BTPLayer(p_type, p_param);
  };
}; // End of class BTPLayerFactory

