/*!
 * \file      BTPLayer.hh
 * \brief     Header file for ITS BTP protocol layer.
 * \author    ETSI STF525
 * \copyright ETSI Copyright Notification
 *            No part may be reproduced except as authorized by written permission.
 *            The copyright and the foregoing restriction extend to reproduction in all media.
 *            All rights reserved.
 * \version   0.1
 */
#pragma once

#include "TLayer.hh"
#include "BTPCodec.hh"

namespace LibItsBtp__TestSystem {
  class BtpPort;
  class BtpReq;
  class BtpInd;
}

class BTPLayer : public TLayer<LibItsBtp__TestSystem::BtpPort> {
  Params _params;
  BTPCodec _codec;
  bool _device_mode;
public:
  BTPLayer() : TLayer<LibItsBtp__TestSystem::BtpPort>(), _params(), _codec(), _device_mode{false} {};
  BTPLayer(const std::string& p_type, const std::string& param);
  virtual ~BTPLayer() {};

  void sendMsg(const LibItsBtp__TestSystem::BtpReq&, Params& param);
    
  virtual void sendData(OCTETSTRING& data, Params& params);
  virtual void receiveData(OCTETSTRING& data, Params& info);
}; // End of class BTPLayer

