/*!
 * \file      ConfigRsuSimulatorLayerFactory.hh
 * \brief     Header file for ITS ConfigRsuSimulator protocol layer factory.
 * \author    ETSI STF525
 * \copyright ETSI Copyright Notification
 *            No part may be reproduced except as authorized by written permission.
 *            The copyright and the foregoing restriction extend to reproduction in all media.
 *            All rights reserved.
 * \version   0.1
 */
#pragma once

#include "LayerStackBuilder.hh"

#include "ConfigRsuSimulatorLayer.hh"

class ConfigRsuSimulatorLayerFactory: public LayerFactory {
  static ConfigRsuSimulatorLayerFactory _f;
public:
  ConfigRsuSimulatorLayerFactory() {
    // Register factory
    LayerStackBuilder::RegisterLayerFactory("CF", this);
  };

  inline virtual Layer * createLayer(const std::string& p_type, const std::string& p_param) {
    return new ConfigRsuSimulatorLayer(p_type, p_param);
  };

}; // End of class ConfigRsuSimulatorLayerFactory

