/*!
 * \file      ConfigRsuSimulatorLayer.hh
 * \brief     Header file for ITS Configuration port protocol layer.
 * \author    ETSI STF525
 * \copyright ETSI Copyright Notification
 *            No part may be reproduced except as authorized by written permission.
 *            The copyright and the foregoing restriction extend to reproduction in all media.
 *            All rights reserved.
 * \version   0.1
 */
#pragma once

#include "TLayer.hh"
#include "ConfigRsuSimulatorCodec.hh"

namespace ItsRSUsSimulator__TestSystem {
  class ConfigRsuSimulatorPort;
  class CfInitialize;
}

class ConfigRsuSimulatorLayer : public TLayer<ItsRSUsSimulator__TestSystem::ConfigRsuSimulatorPort> {
  Params _params;
  ConfigRsuSimulatorCodec _codec;
public:
  ConfigRsuSimulatorLayer() : TLayer<ItsRSUsSimulator__TestSystem::ConfigRsuSimulatorPort>(), _params(), _codec() {};
  ConfigRsuSimulatorLayer(const std::string& p_type, const std::string& param);
  virtual ~ConfigRsuSimulatorLayer() {};

  void sendMsg(const ItsRSUsSimulator__TestSystem::CfInitialize&, Params& params);
    
  virtual void sendData(OCTETSTRING& data, Params& params);
  virtual void receiveData(OCTETSTRING& data, Params& info);
}; // End of class CAMLayer
