// This Test Port skeleton source file was generated by the
// TTCN-3 Compiler of the TTCN-3 Test Executor version CRL 113 200/5 R3A
// for U-ERICSSON\ethgry (ethgry@HU00078339) on Fri Aug 14 16:32:05 2015

// Copyright Ericsson Telecom AB 2000-2014

// You may modify this file. Complete the body of empty functions and
// add your member functions here.

#include "IvimPort.hh"
#include "IVIMLayerFactory.hh"
#include "loggers.hh"

namespace LibItsIvim__TestSystem {

  IvimPort::IvimPort(const char *par_port_name) : IvimPort_BASE(par_port_name), _cfg_params(), _layer_params(), _layer(NULL), _time_key("IvimPort::outgoing_send") {

  }

  IvimPort::~IvimPort()
  {
    if (_layer != NULL) {
      delete _layer;
    }
  }

  void IvimPort::set_parameter(const char * parameter_name, const char * parameter_value)
  {
    loggers::get_instance().log("IvimPort::set_parameter: %s=%s", parameter_name, parameter_value);
    _cfg_params.insert(std::pair<std::string, std::string>(std::string(parameter_name), std::string(parameter_value)));
  }

  /*void IvimPort::Handle_Fd_Event(int fd, boolean is_readable,
    boolean is_writable, boolean is_error) {}*/

  void IvimPort::Handle_Fd_Event_Error(int /*fd*/)
  {

  }

  void IvimPort::Handle_Fd_Event_Writable(int /*fd*/)
  {

  }

  void IvimPort::Handle_Fd_Event_Readable(int /*fd*/)
  {

  }

  /*void IvimPort::Handle_Timeout(double time_since_last_call) {}*/

  void IvimPort::user_map(const char * system_port)
  {
    loggers::get_instance().log(">>> IvimPort::user_map: %s", system_port);
    // Build layer stack
    Params::iterator it = _cfg_params.find(std::string("params"));
    if (it != _cfg_params.end()) {
      loggers::get_instance().log("IvimPort::user_map: %s", it->second.c_str());
      _layer = LayerStackBuilder::GetInstance()->createLayerStack(it->second.c_str());
      if (static_cast<IVIMLayer *>(_layer) == NULL) {
	loggers::get_instance().error("IvimPort::user_map: Invalid stack configuration: %s", it->second.c_str());
      }
      static_cast<IVIMLayer *>(_layer)->addUpperPort(this);
    } else {
      loggers::get_instance().error("IvimPort::user_map: No layers defined in configuration file");
    }
  }

  void IvimPort::user_unmap(const char * system_port)
  {
    loggers::get_instance().log(">>> IvimPort::user_unmap: %s", system_port);
    if (_layer != NULL) {
      delete _layer;
      _layer = NULL;
    }
  }

  void IvimPort::user_start()
  {

  }

  void IvimPort::user_stop()
  {

  }

  void IvimPort::outgoing_send(const IvimReq& send_par)
  {
    loggers::get_instance().log_msg(">>> IvimPort::outgoing_send: payload=", send_par);
    
    float duration;
    loggers::get_instance().set_start_time(_time_key);
    Params params;
    static_cast<IVIMLayer *>(_layer)->sendMsg(send_par, params);
    loggers::get_instance().set_stop_time(_time_key, duration);
  }

  void IvimPort::receiveMsg(const LibItsIvim__TestSystem::IvimInd& p_ind, const Params& p_params) {
    loggers::get_instance().log_msg(">>> IvimPort::receive_msg: ", p_ind);

    incoming_message(p_ind);
  }

} /* end of namespace */

