/*!
 * \file      TLayer.hh
 * \brief     Header file for ITS abstract protocol layer definition.
 * \author    ETSI STF525
 * \copyright ETSI Copyright Notification
 *            No part may be reproduced except as authorized by written permission.
 *            The copyright and the foregoing restriction extend to reproduction in all media.
 *            All rights reserved.
 * \version   0.1
 */
#pragma once

#include "Layer.hh"

template <typename TPort> class TLayer : public Layer {
  typedef std::vector<TPort*> TPortList;
  typedef typename std::vector<TPort*>::iterator TPortListIterator;

  TPortList upperPorts;

public:
  TLayer() : Layer(), upperPorts() { };
  TLayer(const std::string& p_type) : Layer(p_type), upperPorts() { };
  void addUpperPort(TPort * p_port) { upperPorts.push_back(p_port); };
  void removeUpperPort(TPort*);

protected:
  template <typename TMessage>
  inline void toAllUpperPorts(const TMessage& m, const Params& param) {
    for(TPortListIterator it=upperPorts.begin(); it<upperPorts.end(); ++it){
      (*it)->receiveMsg(m, param);
    }
  }
}; // End of class TLayer

