#ifndef CODECPER_H
#define CODECPER_H

#include "Params.hh"
#include "ASN1RecodePer.hh"

class BITSTRING;
class TTCN_Typedescriptor_t;

struct asn_TYPE_descriptor_s;

template<typename TPDU>
class PERCodec : public ASN1RecodePer
{
public:
  virtual int encode(const TPDU& msg, BITSTRING& bits) = 0;
  virtual int decode(const BITSTRING& bits, TPDU& msg) = 0;
  
protected:
  int _decode (const TTCN_Typedescriptor_t& ttcn, const asn_TYPE_descriptor_s & td, const BITSTRING& p_data, TPDU& msg);
  int _encode (const TTCN_Typedescriptor_t& ttcn, const asn_TYPE_descriptor_s & td, const TPDU& msg, BITSTRING& p_data);
}; // End of class PERCodec

#include "PERCodec.t.hh"

#endif
