/*!
 * \file      LayerStackBuilder.hh
 * \brief     Header file for ITS protocol stack builder.
 * \author    ETSI STF525
 * \copyright ETSI Copyright Notification
 *            No part may be reproduced except as authorized by written permission.
 *            The copyright and the foregoing restriction extend to reproduction in all media.
 *            All rights reserved.
 * \version   0.1
 */
#pragma once

#include "LayerFactory.hh"

/*!
 * \class LayerStackBuilder
 * \brief  This class provides a factory class to create Layer class instances
 */
class LayerStackBuilder {
  typedef std::map<std::string, LayerFactory*> LayerFactoryMap;

  static LayerStackBuilder * _instance;
  std::map<std::string, LayerFactory*> _fs;
private:
  LayerStackBuilder(); // can not be created manually
public:
  static LayerStackBuilder * GetInstance();
  static void RegisterLayerFactory(const std::string & type, LayerFactory * f);

public:
  void registerLayerFactory(const std::string & type, LayerFactory * f);
  Layer* createLayerStack(const char*);
}; // End of class LayerStackBuilder

