/**
 * 
 */
package de.fraunhofer.sit.c2x.pki.ca.validator.region;

/**
 * @author Attila Jaeger - TU Darmstadt <br> jaeger@iss.tu-darmstadt.de
 * @version 0.1.1
 *
 */
public class WGSCoordinate {
	
	/** WGS-84 Durchmesser am quator */
	public final static double EquatorialRadius = 6378137;
	/** TODO: insert field comment */
	public final static double eccentricitySquared = 0.00669438;
	
	/** Rechenkonstante */
//	private final static double deg2rad = Math.PI / 180;
	
	private double longitude;
	private double latitude;
	/**
	 * TODO: insert constructor comment
	 * @param longitude
	 * @param latitude
	 */
	public WGSCoordinate(double latitude, double longitude) {
		this.longitude = longitude;
		this.latitude = latitude;
	}

	/**
	 * Converts this WGS84 coordinate in to UTM<p>
	 * To optimize performance for simTD, this works only for UTMZone 32U
	 * 
	 * @return This coordinate as UTM
	 */
	// public UTMCoordinate toUTM() {
	// // double longitude = this.longitude;
	// // double latitude = this.latitude;
	//
	// double a = EquatorialRadius;
	// double eccSquared = eccentricitySquared;
	// double k0 = UTMCoordinate.factor;
	//
	// //Make sure the longitude is between -180.00 .. 179.9
	// longitude += 180;
	// longitude %= 360;
	// if(longitude < 0 )
	// longitude += 360;
	// longitude -= 180;
	//
	// double latRad = latitude*deg2rad;
	// double longRad = longitude*deg2rad;
	//
	// /* compute the UTM Zone from longitude and latitude */
	// //String UTMZone = UTMCoordinate.calcUTMZone(longitude, latitude);
	// // String UTMZone = UTMCoordinate.DefaultUTMZone; // simplification for
	// simTD
	// //int zoneNumber = Integer.valueOf(UTMZone.substring(0,2));
	// //int zoneNumber = 32; // simplification for simTD
	//
	// //double longOrigin = (zoneNumber - 1)*6 - 180 + 3; //+3 puts origin in
	// middle of zone
	// double longOrigin = 9; // simplification for simTD
	// double longOriginRad = longOrigin * deg2rad;
	//
	// //double eccPrimeSquared = (eccSquared)/(1-eccSquared);
	// double eccPrimeSquared = 0.006739496752268451; // simplification for
	// simTD
	//
	// double N = a/Math.sqrt(1-eccSquared*Math.sin(latRad)*Math.sin(latRad));
	// double T = Math.tan(latRad)*Math.tan(latRad);
	// double C = eccPrimeSquared*Math.cos(latRad)*Math.cos(latRad);
	// double A = Math.cos(latRad)*(longRad-longOriginRad);
	//
	// double M = a*((1 - eccSquared/4 - 3*eccSquared*eccSquared/64 -
	// 5*eccSquared*eccSquared*eccSquared/256)*latRad
	// - (3*eccSquared/8 + 3*eccSquared*eccSquared/32 +
	// 45*eccSquared*eccSquared*eccSquared/1024)*Math.sin(2*latRad)
	// + (15*eccSquared*eccSquared/256 +
	// 45*eccSquared*eccSquared*eccSquared/1024)*Math.sin(4*latRad)
	// - (35*eccSquared*eccSquared*eccSquared/3072)*Math.sin(6*latRad));
	//
	// double UTMEasting = (double)(k0*N*(A+(1-T+C)*A*A*A/6 +
	// (5-18*T+T*T+72*C-58*eccPrimeSquared)*A*A*A*A*A/120) + 500000.0);
	// double UTMNorthing =
	// (double)(k0*(M+N*Math.tan(latRad)*(A*A/2+(5-T+9*C+4*C*C)*A*A*A*A/24 +
	// (61-58*T+T*T+600*C-330*eccPrimeSquared)*A*A*A*A*A*A/720)));
	// if(latitude < 0) UTMNorthing += 10000000.0; //10000000 meter offset for
	// southern hemisphere
	//
	// return new UTMCoordinate(UTMEasting, UTMNorthing);
	// }
	//
	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "(" + latitude + ", " + longitude + ")";
	}

	/**
	 * Returns longitude
	 * @return the longitude
	 * @see de.simtd.impl.system.plausibilitychecker.common.WGSCoordinate#longitude
	 */
	public double getLongitude() {
		return longitude;
	}

	/**
	 * Returns latitude
	 * @return the latitude
	 * @see de.simtd.impl.system.plausibilitychecker.common.WGSCoordinate#latitude
	 */
	public double getLatitude() {
		return latitude;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		long temp;
		temp = Double.doubleToLongBits(latitude);
		result = prime * result + (int) (temp ^ (temp >>> 32));
		temp = Double.doubleToLongBits(longitude);
		result = prime * result + (int) (temp ^ (temp >>> 32));
		return result;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		WGSCoordinate other = (WGSCoordinate) obj;
		if (Double.doubleToLongBits(latitude) != Double.doubleToLongBits(other.latitude))
			return false;
		if (Double.doubleToLongBits(longitude) != Double.doubleToLongBits(other.longitude))
			return false;
		return true;
	}
	
	
}