/**
 * 
 */
package de.fraunhofer.sit.c2x.pki.ca.validator.region;

import javax.inject.Inject;

import de.fraunhofer.sit.c2x.pki.ca.validator.region.interfaces.CircularRegion;
import de.fraunhofer.sit.c2x.pki.ca.validator.region.shape.DoubleVector2d;
import de.fraunhofer.sit.c2x.pki.ca.validator.region.utils.Convert;
import de.fraunhofer.sit.c2x.pki.ca.validator.region.utils.LinearMath;


/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 * 
 */
public class CircleCircleValidator extends AbstractCircleValidator<CircularRegion> {

	@Inject
	public CircleCircleValidator() {
		super();
	}
	
	/**
	 * @param circularRegion
	 */
	public CircleCircleValidator(CircularRegion circularRegion) {
		super(circularRegion);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.preserve.pki.ca.validator.Validator#validate(java.lang.Object)
	 */
	@Override
	public boolean validate(CircularRegion regionToValidate) {
		if (regionToValidate == null)
			throw new IllegalArgumentException("<regionToValidate> may not be null");

		DoubleVector2d certCenter = Convert.aTwoDLocation.toVector(regionToValidate.getCenter());
		int certRadius = regionToValidate.getRadiusInt();

		return Convert.round(LinearMath.distanceBetween(caCenter, certCenter), 0) + certRadius <= caRadius;
	}

}
