package de.fraunhofer.sit.c2x.pki.ca.provider.interfaces;

import java.sql.Timestamp;

import de.fraunhofer.sit.c2x.pki.ca.core.interfaces.Service;
import de.fraunhofer.sit.c2x.pki.ca.measuring.MeasuringKey;
import de.fraunhofer.sit.c2x.pki.ca.measuring.MeasuringStatistics;
import de.fraunhofer.sit.c2x.pki.ca.provider.ProviderException;
import de.fraunhofer.sit.c2x.pki.ca.provider.entities.Measuring;

/**
 * @author Norbert Bissmeyer (norbert.bissmeyer@sit.fraunhofer.de)
 */
public interface MeasuringProvider extends Service {

	public boolean add(byte[] stationDigest, byte[] requestHash, MeasuringKey key, long value, int numberOfOperations);
	
	public boolean save(Measuring measuring) throws ProviderException ;
	
	public Measuring get(Timestamp time, byte[] stationDigest, MeasuringKey key) throws ProviderException ;
	
	public Measuring[] getAll(int offset, int limit) throws ProviderException ;
	
	public Measuring[] getRange(Timestamp startTime, Timestamp endTime) throws ProviderException ;
	
	public Measuring[] getKeys(MeasuringKey key) throws ProviderException ;

	int removeMeasuring(Timestamp time, byte[] stationDigest, MeasuringKey key) throws ProviderException;
	
	public MeasuringStatistics getStatistics(Timestamp start, Timestamp end) throws ProviderException;
}
