package de.fraunhofer.sit.c2x.pki.ca.provider.interfaces;

import de.fraunhofer.sit.c2x.pki.ca.core.interfaces.CallBack;
import de.fraunhofer.sit.c2x.pki.ca.core.interfaces.Service;
import de.fraunhofer.sit.c2x.pki.ca.provider.entities.Configuration;

public interface ConfigProvider extends Service {

	String get(String identifier);

	int getInt(String identifier);
	
	int getInt(String identifier, int defaultValue);

	void save(Configuration config);
	
	Configuration[] getAll();

	void registerCallBack(String configId, CallBack callBackClass);

	void deregisterCallBack(String configId, CallBack callBackClass);

	long getLong(String identifier, long defaultValue);

	boolean getBoolean(String identifier, boolean defaultValue);
}
