package de.fraunhofer.sit.c2x.pki.ca.provider.entities;

import java.sql.Timestamp;
import java.util.Arrays;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity
@Table(name = Constants.REVOKED__TABLE)
/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 */
public class RevokedCertificate {

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + Arrays.hashCode(certId);
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		RevokedCertificate other = (RevokedCertificate) obj;
		if (!Arrays.equals(certId, other.certId))
			return false;
		return true;
	}

	@Id
	@Column(name = Constants.REVOKED__COL__ID, columnDefinition = "varbinary(10)", nullable = false)
	private byte[] certId;

	@Column(name = Constants.REVOKED__COL__TIME)
	private Timestamp revocationTime;

	public RevokedCertificate() {
	}

	public RevokedCertificate(byte[] certId) {
		this.certId = certId;
		revocationTime = new Timestamp(System.currentTimeMillis());
	}

	public byte[] getCertId() {
		return certId;
	}

	public void setCertId(byte[] certId) {
		this.certId = certId;
	}

	public Timestamp getRevocationTime() {
		return revocationTime;
	}

	public void setRevocationTime(Timestamp revocationTime) {
		this.revocationTime = revocationTime;
	}

}
