package de.fraunhofer.sit.c2x.pki.ca.provider.entities;

import java.io.Serializable;
import java.sql.Timestamp;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

import de.fraunhofer.sit.c2x.pki.ca.measuring.MeasuringKey;
import de.fraunhofer.sit.c2x.pki.ca.provider.interfaces.CreationTime;

@Entity
@Table(name = Constants.MEASURING__TABLE)
/**
 * @author Norbert Bissmeyer (norbert.bissmeyer@sit.fraunhofer.de)
 */
public class Measuring implements Serializable, CreationTime {
	private static final long serialVersionUID = 1L;

	public Measuring() {
		this.creationTime = new Timestamp(System.currentTimeMillis());
	}
	
	@Id
	@GeneratedValue(strategy = GenerationType.AUTO)
	@Column(name = Constants.MEASURING__COL__ID)
	private long id;

	@Column(name = Constants.MEASURING__COL__TIME)
	private Timestamp creationTime;

	@Column(name = Constants.MEASURING__COL__STATION_TYPE, columnDefinition = "varchar(20)", nullable = false)
	private String stationType;
	
	@Column(name = Constants.MEASURING__COL__STATION_DIGEST, columnDefinition = "varbinary(10)", nullable = false)
	private byte[] stationDigest;
	
	@Column(name = Constants.MEASURING__COL__REQUEST_HASH, columnDefinition = "varbinary(10)", nullable = false)
	private byte[] requestHash;

	@Column(name = Constants.MEASURING__COL__KEY, columnDefinition = "varchar(50)", nullable = false)
	private MeasuringKey key;
	
	@Column(name = Constants.MEASURING__COL__VALUE, columnDefinition = "int", nullable = false)
	private int value;

	@Column(name = Constants.MEASURING__COL__NUMBER, columnDefinition = "int", nullable = false)
	private int numberOperations;
	
	@Override
	public Timestamp getCreationTime() {
		return creationTime;
	}

	@Override
	public void setCreationTime(Timestamp creationTime) {
		this.creationTime = creationTime;
	}

	public String getStationType() {
		return stationType;
	}

	public void setStationType(String stationType) {
		this.stationType = stationType;
	}

	public byte[] getStationDigest() {
		return stationDigest;
	}

	public void setStationDigest(byte[] stationDigest) {
		this.stationDigest = stationDigest;
	}

	public byte[] getRequestHash() {
		return requestHash;
	}

	public void setRequestHash(byte[] requestHash) {
		this.requestHash = requestHash;
	}
	
	public MeasuringKey getKey() {
		return key;
	}
	
	public void setKey(MeasuringKey key) {
		this.key = key;
	}
	
	public int getNumberOperations() {
		return numberOperations;
	}

	public void setNumberOperations(int numberOperations) {
		this.numberOperations = numberOperations;
	}

	public void setKey(String key) {
		for(MeasuringKey m : MeasuringKey.getAll()){
			if(m.toString().equals(key))
				this.key = m;
		}
	}

	public int getValue() {
		return value;
	}

	public void setValue(int value) {
		this.value = value;
	}

	public long getId() {
		return id;
	}

	public void setId(long id) {
		this.id = id;
	}
}