package de.fraunhofer.sit.c2x.pki.ca.provider.entities;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToOne;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;

@Entity
@Table(name = Constants.KEYSTORE__TABLE)
public class Keystore {

	@Id
	@GeneratedValue(strategy = GenerationType.AUTO)
	@Column(name = Constants.KEYSTORE__COL__ID, nullable = true)
	private int id;

	@Column(name = Constants.KEYSTORE__COL__CERT_ID, nullable = true, unique = true, columnDefinition = "varbinary(10)")
	private byte[] certId;

	@Column(name = Constants.KEYSTORE__COL__KEYSTORE, nullable = false, columnDefinition = "blob")
	private byte[] keystore;

	@OneToOne(fetch = FetchType.LAZY)
	@PrimaryKeyJoinColumn
	private CaCertificate certificate;

	@OneToOne(fetch = FetchType.LAZY)
	@PrimaryKeyJoinColumn
	private CrlCertificate crlcertificate;
	
	public Keystore() {
	}
	
	public Keystore(CaCertificate certificate, byte[] keystore) {
		this.certificate = certificate;
		this.certId = certificate.getCertId();
		this.keystore = keystore;
	}
	
	public Keystore(CrlCertificate crlcertificate, byte[] keystore) {
		this.setCrlcertificate(crlcertificate);
		this.certId = this.crlcertificate.getCertId();
		this.keystore = keystore;
	}

	public byte[] getCertId() {
		return certId;
	}

	public void setCertId(byte[] certId) {
		this.certId = certId;
	}

	public byte[] getKeystore() {
		return keystore;
	}

	public void setKeystore(byte[] keystore) {
		this.keystore = keystore;
	}

	public CaCertificate getCertificate() {
		return certificate;
	}

	public void setCertificate(CaCertificate certificate) {
		this.certificate = certificate;
	}

	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}

	public CrlCertificate getCrlcertificate() {
		return crlcertificate;
	}

	public void setCrlcertificate(CrlCertificate crlcertificate) {
		this.crlcertificate = crlcertificate;
	}

}
