package de.fraunhofer.sit.c2x.pki.ca.provider.entities;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Embeddable;

@Embeddable
/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 */
public class Host implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	public Host() {
	}

	@Column(name = Constants.HOST__COL__ADDRESS, nullable = false)
	private String adress;

	@Column(name = Constants.HOST__COL__PORT_HTTP, nullable = false)
	private Short httpPort;

	@Column(name = Constants.HOST__COL__PORT_UDP, nullable = true)
	private Short udpPort;

	@Column(name = Constants.HOST__COL__WSDL_URL, nullable = false)
	private String wsdlUrl;

	public String getAdress() {
		return adress;
	}

	public void setAdress(String adress) {
		this.adress = adress;
	}

	public Short getHttpPort() {
		return httpPort;
	}

	public void setHttpPort(Short httpPort) {
		this.httpPort = httpPort;
	}

	public Short getUdpPort() {
		return udpPort;
	}

	public void setUdpPort(Short udpPort) {
		this.udpPort = udpPort;
	}

	public String getWsdlUrl() {
		return wsdlUrl;
	}

	public void setWsdlUrl(String wsdlUrl) {
		this.wsdlUrl = wsdlUrl;
	}

}
