package de.fraunhofer.sit.c2x.pki.ca.module.webservice.service;

import java.net.InetSocketAddress;
import java.util.NoSuchElementException;

import javax.annotation.Resource;
import javax.inject.Inject;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.ws.Action;
import javax.xml.ws.WebServiceContext;

import org.apache.log4j.Logger;
import org.eclipse.jetty.http.spi.JettyHttpsExchange;

import de.fraunhofer.sit.c2x.pki.ca.core.exceptions.HandlerException;
import de.fraunhofer.sit.c2x.pki.ca.core.logging.InjectLogger;
import de.fraunhofer.sit.c2x.pki.ca.module.webservice.handler.interfaces.CaCertificateRequestHandler;
import de.fraunhofer.sit.c2x.pki.ca.module.webservice.handler.interfaces.CrlRequestHandler;
import de.fraunhofer.sit.c2x.pki.ca.module.webservice.handler.interfaces.RequestErrorHandler;

@WebService(serviceName = "RcaWeb", portName = "RcaWebPort", targetNamespace = "http://http.rca.pki.c2x.sit.fraunhofer.de/RcaWebService")
@SOAPBinding(style = SOAPBinding.Style.RPC)
public class RcaWebService implements de.fraunhofer.sit.c2x.pki.ca.module.webserver.interfaces.WebService {

	@Resource
	WebServiceContext wsContext;
	private InetSocketAddress remoteAddress;

	@InjectLogger
	private Logger logger;
	
	@Inject
	private RequestErrorHandler errorHandler;

	@Inject
	private CaCertificateRequestHandler cacertHandler;

	@Inject
	private CrlRequestHandler crlRequestHandler;

	/**
	 * 
	 * @param crlRequest
	 * @return returns byte[]
	 */
	@WebMethod
	@WebResult(partName = "return")
	@Action(input = "http://http.rca.pki.c2x.sit.fraunhofer.de/RcaWebService/processCrlRequestRequest", output = "http://http.rca.pki.c2x.sit.fraunhofer.de/RcaWebService/processCrlRequestResponse")
	public byte[] processCrlRequest(@WebParam(name = "crlRequest", partName = "crlRequest") byte[] crlRequest) {
		try {
			if (logger.isDebugEnabled())
				logger.debug("START: handling of a CRL Request from " + getRemoteAddress());

			byte[] responseBytes = crlRequestHandler.handle(crlRequest);

			if (logger.isDebugEnabled())
				logger.debug("END: handling of a CRL Request from " + getRemoteAddress() + " (successful)");
			return responseBytes;
		} catch (HandlerException e) {
			if (logger.isDebugEnabled()) {
				logger.debug("Error handling a CRL Request from " + getRemoteAddress()
						+ ": " + e.getMessage());
				logger.debug("END: handling of a CRL Request from " + getRemoteAddress()
						+ " (failed)");
			}
			return errorHandler.handle(crlRequest, e);
		}
	}

	/**
	 * 
	 * @param certificateDownloadRequest
	 * @return returns byte[]
	 */
	@WebMethod
	@WebResult(partName = "return")
	@Action(input = "http://http.rca.pki.c2x.sit.fraunhofer.de/RcaWebService/processCertificateDownloadRequestRequest", output = "http://http.rca.pki.c2x.sit.fraunhofer.de/RcaWebService/processCertificateDownloadRequestResponse")
	public byte[] processCertificateDownloadRequest(
			@WebParam(name = "certificateDownloadRequest", partName = "certificateDownloadRequest") byte[] certificateDownloadRequest) {
		try {
			if (logger.isDebugEnabled())
				logger.debug("START: handling of a Certificate Download Request from " + getRemoteAddress());

			byte[] responseBytes = cacertHandler.handle(certificateDownloadRequest);

			if (logger.isDebugEnabled())
				logger.debug("END: handling of a Certificate Download Request from " + getRemoteAddress()
						+ " (successful)");
			return responseBytes;
		} catch (HandlerException e) {
			if (logger.isDebugEnabled()) {
				logger.debug("Error handling a Certificate Download Request from " + getRemoteAddress()
						+ ": " + e.getMessage());
				logger.debug("END: handling of a Certificate Download Request from " + getRemoteAddress()
						+ " (failed)");
			}
			return errorHandler.handle(certificateDownloadRequest, e);
		}
	}

	private InetSocketAddress getRemoteAddress() {
		if (remoteAddress != null) {
			return remoteAddress;
		} else {
			Object o = wsContext.getMessageContext().get("com.sun.xml.internal.ws.http.exchange");
			if (o == null || !o.getClass().equals(JettyHttpsExchange.class)) {
				throw new NoSuchElementException("No http exchange found to get remote IP address");
			}
			JettyHttpsExchange exchange = (JettyHttpsExchange) o;
			remoteAddress = exchange.getRemoteAddress();
			return remoteAddress;
		}
	}

	@Override
	public String getPath() {
		return "/RcaWebService";
	}

}
