package de.fraunhofer.sit.c2x.pki.ca.module.webserver.utils;

import javax.servlet.http.HttpSession;

import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class HtmlUtils {

	public static String headAsHtml(String webpageTitle) {

		StringBuilder sb = new StringBuilder();
		sb.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n");
		sb.append("<html xmlns=\"http://www.w3.org/1999/xhtml\">\n");
		sb.append("<head>\n");
		sb.append("<script src=\"/webpage/main.js\" type=\"text/javascript\"></script>\n");
		sb.append("<title>");
		sb.append(webpageTitle);
		sb.append("</title>\n");
		sb.append("<link rel=\"stylesheet\" href=\"/webpage/css/style.css\" type=\"text/css\" media=\"all\" />\n");
		sb.append("</head>\n");

		return sb.toString();
	}

	public static String bodyAsHtml(String title, String pageTitle,
			String contentHtml, String webpageMenu, String webpageFooter) {

		StringBuilder sb = new StringBuilder();

		sb.append("<body>\n");
		sb.append(getWebpageHeadAsHtml(title));
		sb.append("<div id=\"content\">\n");
		sb.append(webpageMenu);
		sb.append("<div id=\"right\">\n");
		sb.append(String.format("<h1>%s</h1>\n", pageTitle));
		sb.append(contentHtml);
		sb.append("</div>\n" + "</div>\n");
		sb.append(webpageFooter);
		sb.append("</body>\n" + "</html>\n");

		return sb.toString();

	}

	private static String getWebpageHeadAsHtml(String title) {
		String str = "<div id=\"header\">\n" + "	<p class=\"logotext\">"
				+ title + " <strong>Admin</strong></p>\n" + "</div>\n"
				+ "<div id=\"nav\">" + "</div>\n";
		return str;
	}

	public static String getWebpageFootHtml(String alternativeImageText,
			String footerText, String projectLogo) {

		StringBuilder sb = new StringBuilder();
		sb.append("<!-- content end -->\n");
		sb.append("<br class=\"clear\" />\n");
		sb.append("<div id=\"footer\">\n");
		sb.append("<center>\n");
		sb.append("<p>");
		sb.append(footerText);
		sb.append("</p>\n");
		sb.append("<p><img src=\"/webpage/images/sit.png\" border=\"0\" alt=\"Fraunhofer SIT\" />\n");
		sb.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
		sb.append("<img src=\"/webpage/images/");
		sb.append(projectLogo);
		sb.append("\" style=\"position: relative; top: 10px;\" border=\"0\" alt=\"");
		sb.append(alternativeImageText + "\" /></p>\n" + "</center>\n" + "</div>\n");
		return sb.toString();
	}

	public static String getWebpageMenuAsHtml(HttpSession session) {
		return "";
	}

	public static String getFormatedUptime(long milliseconds) {

		String output = "";

		DateTime dt = new DateTime(milliseconds, DateTimeZone.UTC);
		if (milliseconds > 1000 * 60 * 60 * 24) {
			output += String.format("%d day%s, ", dt.getDayOfYear(),
					(dt.getDayOfYear() > 1) ? "s" : "");
		}
		if (milliseconds > 1000 * 60 * 60) {
			output += String.format("%d hour%s, ", dt.getHourOfDay(),
					(dt.getHourOfDay() > 1) ? "s" : "");
		}
		if (milliseconds > 1000 * 60) {
			output += String.format("%d minute%s, ", dt.getMinuteOfHour(),
					(dt.getMinuteOfHour() > 1) ? "s" : "");
		}
		if (milliseconds > 1000) {
			output += String.format("%d second%s", dt.getSecondOfMinute(),
					(dt.getSecondOfMinute() > 1) ? "s" : "");
		}

		return output;
	}
}
